package com.inet.samples.collation;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;

import com.inet.logging.LogManager;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;

/**
 * Server plugin which registers a custom collator with sorting according to DIN 5007-2. This collator is used for sorting which can't process on the database. 
 */
@PluginInfo( //
id = "collation",// 
dependencies = "reporting", // only for plugin store, could still be used in other products
group = "samples", //
flags = "designer", // also load in designer
version = "25.10.219", //
icon = "com/inet/samples/collation/cust_sorting_48.png" //
)
public class CollationServerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        try {
            spm.register( Collator.class, getDIN5007_2_Collator() );
        } catch( Exception ex ) {
            LogManager.getConfigLogger().error( ex );
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }

    protected Collator getDIN5007_2_Collator() throws Exception {
        Collator collator = Collator.getInstance( Locale.GERMAN );

        String DIN5007_2_tailorings = "& ae , a\u0308 & AE , A\u0308" + "& oe , o\u0308 & OE , O\u0308" + "& ue , u\u0308 & UE , u\u0308";

        collator = new RuleBasedCollator( ((RuleBasedCollator)collator).getRules() + DIN5007_2_tailorings );

        String rules = ((RuleBasedCollator)collator).getRules();
        rules = rules.replaceAll( "<'_'", "<' '<'_'" );

        collator = new RuleBasedCollator( rules );

        collator.setStrength( Collator.IDENTICAL );
        collator.setDecomposition( Collator.NO_DECOMPOSITION );

        return collator;
    }

}
